const http = require('http')

module.exports = class Server {
    static server = null

    static init(data) {
        const { port, url } = data

        this.server = http.createServer((req, res) => {
            res.writeHead(200, { 'Content-Type': 'text/html' })
            res.end('Server is running\n')
        })

        this.server.listen(port, () => {
            console.log(`[SERVER] Application already running : ${url || `http://localhost:${port}`}`)
        })

        this.server.on('error', (err) => {
            console.error('[SERVER] Error:', err.message)
        })
    }
}
